/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.css.core.build;

import com.aptana.core.build.IProblem;
import com.aptana.core.build.RequiredBuildParticipant;
import com.aptana.core.util.ArrayUtil;
import com.aptana.css.core.parsing.ast.CSSCommentNode;
import com.aptana.index.core.build.BuildContext;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.ast.IParseRootNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSSTaskDetector
extends RequiredBuildParticipant {
    private static final String COMMENT_ENDING = "*/";

    public void buildFile(BuildContext context, IProgressMonitor monitor) {
        if (context == null) {
            return;
        }
        Collection<IProblem> tasks = this.detectTasks(context, monitor);
        context.putProblems("com.aptana.core.task", tasks);
    }

    public void deleteFile(BuildContext context, IProgressMonitor monitor) {
        if (context == null) {
            return;
        }
        context.removeProblems("com.aptana.core.task");
    }

    private Collection<IProblem> detectTasks(BuildContext context, IProgressMonitor monitor) {
        if (context == null) {
            return Collections.emptyList();
        }
        try {
            return this.detectTasks(context.getAST(), context, monitor);
        }
        catch (CoreException coreException) {
            return Collections.emptyList();
        }
    }

    public Collection<IProblem> detectTasks(IParseRootNode rootNode, BuildContext context, IProgressMonitor monitor) {
        if (context == null || rootNode == null) {
            return Collections.emptyList();
        }
        Object[] comments = rootNode.getCommentNodes();
        if (ArrayUtil.isEmpty((Object[])comments)) {
            return Collections.emptyList();
        }
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)comments.length);
        ArrayList<IProblem> tasks = new ArrayList<IProblem>(comments.length);
        try {
            String source = context.getContents();
            String filePath = context.getURI().toString();
            Object[] objectArray = comments;
            int n = comments.length;
            int n2 = 0;
            while (n2 < n) {
                Object commentNode = objectArray[n2];
                if (commentNode instanceof CSSCommentNode) {
                    tasks.addAll(this.processCommentNode(filePath, source, 0, (IParseNode)commentNode, COMMENT_ENDING));
                }
                sub.worked(1);
                ++n2;
            }
        }
        finally {
            sub.done();
        }
        return tasks;
    }
}

